﻿/*
VERSION:  1.1
1.1		Change:  Write the CMD to a file before running it to ensure that it runs.

Requires Zinc

USAGE:
	#include "functions/VOW/zincMultiSave.as"
	var file = zincMultiSave();
	#include "functions/readExif.as"
	var image_path = "folder with spaces\\137f582e1dd12f73.png";
	var values = EXIF_TAGS | EXIF_ARTIST;
	var exiftool_path = "exiftool.exe";
	readExif( image_path, values, file.save, exiftool_path ).then = function( output ){
		mdm.Exception.DebugWindow.trace( "artist: " + output.artist );
		for(var tag in output.tags){
			mdm.Exception.DebugWindow.trace( tag );
		}
	}
*/
var EXIF_ARTIST = 1;
var EXIF_TAGS = 2;
var EXIF_URL = 4;
var EXIF_COPYRIGHT = 8;
var EXIF_COMMENT = 16;
#include "functions/VOW.as"
function readExif( image_path, readParams, zincSave, exiftool_path ){
	var appPath = mdm.Application.path;
	if( !appPath ){
		mdm.Exception.DebugWindow.trace("ERROR:  Missing Zinc");
		return VOW.make().doBreak();
	}
	if( !image_path ){
		mdm.Exception.DebugWindow.trace("ERROR:  Missing image path");
		return VOW.make().doBreak();
	}
	if( !exiftool_path ){
		exiftool_path = "exiftool.exe";
	}
	if( exiftool_path.substr( -4 ) !== ".exe" ){
		exiftool_path = exiftool_path + ".exe";
	}
	if( image_path.indexOf(":\\") === -1 ){
		image_path = appPath + image_path;
	}
	if( exiftool_path.indexOf(":\\") === -1 ){
		exiftool_path = appPath + exiftool_path;
	}
	if( !mdm.FileSystem.fileExistsUnicode( image_path )  ){
		mdm.Exception.DebugWindow.trace("ERROR:  Image file doesn't exist at:  " + image_path);
		return VOW.make().doBreak();
	}
	if( !mdm.FileSystem.fileExistsUnicode( exiftool_path )  ){
		mdm.Exception.DebugWindow.trace("ERROR:  exiftool.exe doesn't exist at:  " + exiftool_path);
		return VOW.make().doBreak();
	}
	var prom = VOW.make();
	// decode readParams
	var read_artist = ( readParams & EXIF_ARTIST ) > 0;
	var read_tags = ( readParams & EXIF_TAGS ) > 0;
	var read_url = ( readParams & EXIF_URL ) > 0;
	var read_copyright = ( readParams & EXIF_COPYRIGHT ) > 0;
	var read_comment = ( readParams & EXIF_COMMENT ) > 0;
	
	// read keywords from the image file, using EXIFtool.exe
	var cmd = '';
	cmd += '"' + exiftool_path + '"';
	if( read_artist )
		cmd += ' -creator';
	if( read_tags )
		cmd += ' -keywords -XPKeywords';
	if( read_url )
		cmd += ' -source -CreatorWorkURL';
	if( read_copyright )
		cmd += ' -copyright';
	if( read_comment )
		cmd += ' -UserComment';
	cmd += ' -s -s ';
	cmd += '"' + image_path + '"';
	
	
	// save CMD script
	var fileName = "readExif_" + Math.floor( Math.random() * 9999 ) + ".cmd";
	var cmd_path = appPath + fileName;
	zincSave( cmd_path, cmd )
	.then = function(){
		// run script
		var output_str = mdm.System.execStdOut( cmd_path );
		// clean up
		if( cmd_path  &&  mdm.FileSystem.fileExistsUnicode( cmd_path ) === true  ){
			mdm.FileSystem.deleteFileUnicode( cmd_path );
		}
		
		// clean-up the output
		// // remove extra carriage returns  +  remove the input command
		var enter13 = String.fromCharCode( 13 );		// A windows carriage-return consists of both.  enter13 followed by enter10
		var enter10 = String.fromCharCode( 10 );
		output_str = output_str.split( enter10 ).join("");		// remove redundant carriage-return
		output_str = output_str.split( enter13+enter13 ).join( enter13 );		// remove blank lines
		while( output_str.charAt( 0 ) === enter13 )													// remove first carriage-return
			output_str = output_str.substr( 1 );
		while( output_str.charAt( output_str.length-1 ) === enter13 )				// remove last carriage-return
			output_str = output_str.substr( 0, output_str.length-1 );
		var output_ary = output_str.split( enter13 );
		output_ary.splice( 0, 1 );		// remove the first line  (the input command)
		
		// parse the output
		var artist_output;
		var url_output;
		var copyright_output;
		var comment_output;
		var tags_output;
		var tags_str = "";
		var xptags_str = "";
		for(var i=0; i<output_ary.length; i++){
			var line = output_ary[i];
			var valueAt = line.indexOf(": ") + 2;
			
			if( line.indexOf("Creator: ") > -1 )
				artist_output = line.substr( valueAt );
				
			else if( line.indexOf("CreatorWorkURL: ") > -1 )
				url_output = line.substr( valueAt );
			else if( line.indexOf("Source: ") > -1 )
				url_output = url_output || line.substr( valueAt );
				
			else if( line.indexOf("Copyright: ") > -1 )
				copyright_output = line.substr( valueAt );
			
			else if( line.indexOf("UserComment: ") > -1 )
				comment_output = line.substr( valueAt );
			
			else if( line.substr( 0,10 ) === "Keywords: " )
				tags_str = line.substr( valueAt );
			else if( line.substr( 0,12 ) === "XPKeywords: " )
				xptags_str = line.substr( valueAt );
		}// for each item
		
		// tags
		// // normalize the delimiters
		tags_str = tags_str.split(", ").join(";");
		xptags_str = xptags_str.split(", ").join(";");
		tags_str = tags_str.split(",").join(";");
		// // string => array
		var newTags_ary = tags_str.split(";");
		var xpNewTags_ary = xptags_str.split(";");
		// // array => look-up object
		tags_output = {};
		for(var i=0; i<newTags_ary.length; i++){
			var tag = newTags_ary[i].toLowerCase();
			tags_output[ tag ] = true;
		}
		for(var i=0; i<xpNewTags_ary.length; i++){
			var tag = xpNewTags_ary[i].toLowerCase();
			tags_output[ tag ] = true;
		}
		//
		var hasTags = (newTags_ary.length > 0)  ||  (xpNewTags_ary.length > 0);
		
		// output
		var output = {};
		if( artist_output )
			output.artist = artist_output;
		if( url_output )
			output.url = url_output;
		if( copyright_output )
			output.copyright = copyright_output;
		if( comment_output )
			output.comment = comment_output;
		if( hasTags )
			output.tags = tags_output;
		//
		prom.keep( output );
	}// saving done
	//
	return prom;
}// readExif()